<?php

namespace Drupal\afterburner\Commands;

use Drupal\Core\Site\Settings;
use Drush\Commands\DrushCommands;
use Spatie\Async\Pool;

class AfterburnerCommands extends DrushCommands {

  /**
   * @command afterburner:process-tasks
   *
   * @param string $callbackClass
   * @param int $id
   * @param int $concurrency
   * @param int $timeout
   * @param int $sleepTime
   *
   * @return void
   */
  public function processTasks(string $callbackClass, int $id, int $concurrency, int $timeout, int $sleepTime): void {
    $pool = (Pool::create())
      ->concurrency($concurrency)
      ->timeout($timeout)
      ->sleepTime($sleepTime)
      ->withBinary(Settings::get('php_binary') ?? PHP_BINARY);

    $tasks = call_user_func([$callbackClass, 'getTasks'], $id);
    foreach ($tasks as $task) {
      $pool->add($task);
    }

    $pool->wait();
  }

}
