<?php

namespace Drupal\afterburner_queue\Task;

use Drupal\afterburner\Task\TaskBase;
use Drupal\Core\Queue\DelayableQueueInterface;
use Drupal\Core\Queue\DelayedRequeueException;
use Drupal\Core\Queue\RequeueException;
use Drupal\Core\Queue\SuspendQueueException;

class QueueItemTask extends TaskBase {

  private string $queueName;

  private \stdClass $item;

  /**
   * @param string $queueName
   * @param \stdClass $item
   */
  public function __construct(string $queueName, \stdClass $item) {
    parent::__construct();

    $this->queueName = $queueName;
    $this->item = $item;
  }

  /**
   * @return void
   */
  public function run(): void {
    $queue = \Drupal::service('queue')->get($this->queueName);
    $worker = \Drupal::service('plugin.manager.queue_worker')
      ->createInstance($this->queueName);
    $item = $this->item;

    try {
      $worker->processItem($item->data);
      $queue->deleteItem($item);
    }
    catch (RequeueException|SuspendQueueException $e) {
      $queue->releaseItem($item);
      throw $e;
    }
    catch (DelayedRequeueException $e) {
      if ($queue instanceof DelayableQueueInterface) {
        $queue->delayItem($item, $e->getDelay());
      }
    }
  }

}
