<?php

namespace Drupal\afterburner\EventSubscriber;

use Drupal\Component\EventDispatcher\Event;
use Drupal\Core\Site\Settings;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\Process\Process;

abstract class AfterburnerTasksSubscriberBase implements EventSubscriberInterface {

  private const DRUSH_BINARY = DRUPAL_ROOT . '/../vendor/bin/drush';
  private const COMMAND = 'afterburner:process-tasks';

  private string $uri = '';
  private bool $processTasks = FALSE;
  private int $concurrency = 20;
  private int $timeout = 300;
  private int $sleepTime = 50000;
  private string $callbackClass;
  private int $id;

  public function processTasksOnTerminate(Event $event): void {
    $this->processTasks = TRUE;
  }

  public function setUri(string $uri): void {
    $this->uri = $uri;
  }

  public function setConcurrency(int $concurrency): void {
    $this->concurrency = $concurrency;
  }

  public function setTimeout(int $timeout): void {
    $this->timeout = $timeout;
  }

  public function setSleepTime(int $sleepTime): void {
    $this->sleepTime = $sleepTime;
  }

  public function setCallbackClass(string $callbackClass): void {
    $this->callbackClass = $callbackClass;
  }

  public function setId(int $id): void {
    $this->id = $id;
  }

  protected function shouldProcessTasks(): bool {
    return $this->processTasks;
  }

  public function terminate(): void {
    if (!$this->shouldProcessTasks()) {
      return;
    }

    $phpBinary = Settings::get('php_binary') ?? PHP_BINARY;

    $command = implode(' ', array_filter([
      escapeshellarg($phpBinary),
      escapeshellarg(self::DRUSH_BINARY),
      self::COMMAND,
      ($this->uri ? "--uri={$this->uri}" : NULL),
      escapeshellarg($this->callbackClass),
      escapeshellarg($this->id),
      escapeshellarg($this->concurrency),
      escapeshellarg($this->timeout),
      escapeshellarg($this->sleepTime)
    ]));

    $process = Process::fromShellCommandline($command);
    $process->run();
  }

  abstract public static function getTasks(int $id): array;

  public static function getSubscribedEvents(): array {
    return [
      KernelEvents::TERMINATE => [['terminate']],
    ];
  }

}
