<?php

namespace Drupal\Tests\agreement\Functional;

/**
 * Tests success destination.
 *
 * @group agreement
 */
class AgreementSuccessDestinationTest extends AgreementTestBase {

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->config('system.site')->set('page.front', '/node')->save();
  }

  /**
   * Tests success destination.
   *
   * @param string $expected
   *   The expected path.
   * @param string $successDestination
   *   The success destination path to test.
   * @param string $originatingPath
   *   THe path, if non-empty, that the user should originate from.
   *
   * @throws \Behat\Mink\Exception\ResponseTextException
   * @throws \Drupal\Core\Entity\EntityStorageException
   *
   * @dataProvider successDestinationProvider
   */
  public function testSuccessDestination(string $expected, string $successDestination, string $originatingPath): void {
    $settings = $this->agreement->getSettings();
    $settings['visibility']['settings'] = 0;
    $settings['visibility']['pages'] = [];
    $settings['destination'] = $successDestination;
    $this->agreement->set('settings', $settings);
    $this->agreement->save();

    // Login first so that we can check go to the originating path first.
    // Otherwise the session will be overwritten after login.
    $account = $this->createUnprivilegedUser();
    $this->drupalLogin($account);

    if ($originatingPath) {
      $this->drupalGet($originatingPath);
    }

    $this->assertAgreed($this->agreement);

    $this->assertEquals($this->getAbsoluteUrl($expected), $this->getUrl());
  }

  /**
   * Provides success destination test arguments.
   *
   * @return array[]
   *   An array of test arguments keyed by test name.
   */
  public static function successDestinationProvider(): array {
    return [
      'tests redirect to /node' => ['/node', '/node', ''],
      'tests redirect to <front>' => ['/', '<front>', '/node'],
      'tests default redirect after login' => ['/user/2?check_logged_in=1', '', ''],
      'tests default redirect from when starting at /node' => ['/node', '', '/node'],
    ];
  }

}
