<?php

namespace Drupal\agui\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Controller for the AG-UI demo page.
 */
class AguiDemoController extends ControllerBase {

  /**
   * Renders the AG-UI demo page.
   *
   * @return array
   *   A render array.
   */
  public function demo(): array {
    return [
      '#title' => $this->t('AG-UI Chat Demo'),
      'description' => [
        '#type' => 'html_tag',
        '#tag' => 'p',
        '#value' => $this->t('Select a Drupal AI Assistant or enter a custom AG-UI endpoint to test the chat interface.'),
        '#attributes' => [
          'class' => ['agui-demo-description'],
        ],
      ],
      'form' => $this->formBuilder()->getForm('Drupal\agui\Form\AguiDemoForm'),
      // Chat renders outside the form to prevent form submission conflicts.
      'chat_container' => [
        '#type' => 'container',
        '#attributes' => [
          'id' => 'agui-chat-container',
          'class' => ['agui-demo-chat-container'],
        ],
      ],
    ];
  }

}

