# AG-UI

AG-UI provides an advanced graphical user interface for managing and interacting with AI models within the Drupal ecosystem.

## Components

### Chat (SDC: `agui:chat`)
An agentic chat component for integrating AI agents into Drupal templates. The chat SDC exposes props and a named slot so you can customize behaviour and markup. The component schema is authoritative — use the props below when rendering the SDC.

Usage (Twig example):
```twig
{# Example: render the chat component with the props the SDC expects #}
{{ agui_component('agui:chat', {
  endpoint: '/agui/api/chat',
  agentId: 'default',
  tokenEndpoint: '/agui/api/token',
  suggestions: [
    { title: 'Show weather', message: 'What is the weather today?' },
    { title: 'Search site', message: 'Search for contributors' }
  ],
  debug: false
}) }}
```

Props (component schema)
| Prop          | Type           | Default            | Description |
|---------------|----------------|--------------------|-------------|
| endpoint      | string         | `/agui/api/chat`   | API endpoint used by the chat component. Can be a Drupal route or an external URL when using a remote endpoint. |
| agentId       | string         | —                  | Identifier for the agent to use (matches an agent configured in the module). |
| tokenEndpoint | string         | `/agui/api/token`  | (Optional) token controller endpoint to request short-lived JWTs for authenticating direct/remote calls. |
| suggestions   | array<object>  | —                  | Optional array of suggestion objects rendered as pills. Each item: { title: string, message: string }.
| debug         | boolean        | false              | Enable debug mode for verbose logging.

Slots
- tools — Slot for tool renderer components. Add tool SDCs here to provide custom UIs for specific tools (e.g., weather cards, search results). Each tool SDC provides templates and JS that register with the chat.

## API

- `POST /agui/api/chat`
  Endpoint used by the chat component to communicate with the backend. Payload and response shapes depend on your agent implementation; typically include message content, role, metadata and streaming chunks when enabled on the backend.

## Token controller (JWTs)

The module provides a token controller to issue short-lived JWTs for client-side use (for example when the chat frontend needs to call a remote endpoint directly). By default the token endpoint is `/agui/api/token` and it accepts authenticated requests from Drupal users to mint scoped tokens. Check the module's routing and permission definitions and the examples README for usage patterns and configuration.

## Demo behaviour

The bundle includes a demo that shows two modes:
- Drupal assistant — the chat UI posts to the local Drupal agent endpoint and the server-side agent runs inside Drupal; useful for local testing and when you want Drupal to mediate access to contrib integrations.
- Remote endpoint — the chat UI calls an external/remote endpoint directly (for example a hosted assistant or proxy). When using remote endpoints, the token controller can provide short-lived JWTs so the browser can authenticate safely.

## Tools and examples

This README intentionally keeps tooling notes light — for examples of tool integrations (tools, tool selectors, or plugin usage) see the module examples README at `modules/custom/agui/examples/README.md`.

## Notes

- Use the SDC name `agui:chat` in templates.
- Ensure backend routes and permissions are configured for the `/agui/api/chat` and token endpoints when used.
- Prefer using the demo and examples to validate agent configuration before wiring a production endpoint.
