# Tool Renderer Examples

This folder contains examples showing different ways to create custom UI renderers
for AG-UI Chat tools.

## Two Approaches

### 1. Simple: JavaScript-Only Tool Renderer

**File:** `simple-tool-renderer.js`

Best for quick, lightweight tools where you want everything in one file.
Uses inline HTML in JavaScript.

**Pros:**
- Single file, easy to share
- No Twig/CSS dependencies
- Works as a standalone library

**Cons:**
- HTML is mixed with JavaScript
- Harder to theme/customize
- Styles must be injected dynamically

### 2. Complex: SDC (Single Directory Component) Tool Renderer

**Example:** `components/weather-tool/`

Best for production tools that need:
- Clean separation of concerns (HTML, CSS, JS)
- Drupal theming/overriding
- Proper asset management

**Pros:**
- HTML in Twig templates (themable)
- CSS as a separate file (overridable)
- Follows Drupal SDC patterns
- Uses `<template>` elements for clean JS

**Cons:**
- More files to manage
- Requires SDC knowledge

## Usage

### Simple Tool (Library Attachment)

```php
$build['#attached']['library'][] = 'my_module/my_tool_renderer';
```

### Complex Tool (SDC in Chat Slot)

```php
$build['chat'] = [
  '#type' => 'component',
  '#component' => 'agui:chat',
  '#props' => [...],
  '#slots' => [
    'tools' => [
      ['#type' => 'component', '#component' => 'my_module:my-tool'],
    ],
  ],
];
```

## Registration Methods

All tools register using the same AG-UI Tools API:

```javascript
// Method 1: Queue (before API is ready)
window.AguiToolsQueue = window.AguiToolsQueue || [];
window.AguiToolsQueue.push({
  name: 'tool_name',
  config: { render: (ctx) => { ... } },
});

// Method 2: Direct (if API is available)
if (window.AguiTools) {
  window.AguiTools.register('tool_name', { render: (ctx) => { ... } });
}

// Method 3: Event listener (guaranteed to work)
window.addEventListener('agui:tools:ready', (e) => {
  e.detail.api.register('tool_name', { render: (ctx) => { ... } });
});
```

## Render Context

The `render` function receives a context object:

```javascript
{
  toolName: string,     // The tool being called
  args: object,         // Arguments passed to the tool
  status: string,       // 'pending' | 'streaming' | 'complete' | 'error'
  result: any,          // Tool result (when complete)
  container: HTMLElement // DOM element to render into
}
```

