# Contributing

The AI module is at the time of writing almost 100k lines of code, and has a lot of moving components. It is a complex module that is both trying to be stable and at the same time trying to be bleeding edge things. This means that we need a lot of help to keep the module and its submodules in a good state.

We believe that an thriving AI community is vital for the success of Drupal and that the AI as a whole is moving so fast that one or two people cannot keep up with the pace of change. This is why we are asking for your help to contribute to the AI module.

There are a lot of ways to contribute to the AI module, and we are grateful for any help we can get. If your company has greater goals with the contribution, please be aware of the [Drupal AI Initiative Strategy](https://new.drupal.org/ai/announcement).

## Before Contributing

When creating new issues or updating existing ones, it's important to use good content and metadata such as a clear title, steps to reproduce, component, etc.

Please make sure you follow the [AI module issue guidelines](issue_guidelines.md).

## How to Contribute

The AI module is a complex module with many moving parts, and we need help in various areas to keep it running smoothly. Here are some ways you can contribute:

- **Bug reporting and/or fixing**: Help us find and report bugs in the AI module. This is crucial for maintaining the quality and stability of the module. Read more in the [Contribute Bug Reports](bug_finding.md) section.
- **Feature requests and/or implementation**: If you have an idea for a new feature or improvement, please create a feature request in the [AI Issue queue](https://www.drupal.org/project/issues/ai?categories=All). If you are able to implement the feature, please create a merge request. Read more in the [Contribute Features](features.md) section.
- **Testing**: Help us test the AI module and its submodules, either manually or by writing testing scripts. This is crucial for ensuring that the module works as expected across different environments and use cases. Read more in the [Contribute Testing](testing.md) section.
- **Documentation**: Help us improve the documentation for the AI module. This is crucial for helping users and developers understand how to use and contribute to the AI module effectively. Read more in the [Contribute Documentation](documentation.md) section.
- **Code contributions**: If you are a developer, you can contribute code to the AI module. This includes writing new features, fixing bugs, and improving existing code. Read more in the [Developer Information](developer_information.md) section.
- **Issue triage**: Issue metadata (such as status, component, priority, and tags) are very important to help with efficient issue management. You can help by reviewing issues and updating the metadata when you see mistakes. Read more in the [Issue Guidelines](issue_guidelines.md) section.

