# AI 404 Redirect

This Drupal module uses artificial intelligence to analyze 404 errors and automatically suggest redirects to appropriate content on your website.

## Features

- **AI-Powered Analysis**: Uses the Drupal AI module to analyze 404 errors and determine if a redirect should be created
- **Smart Matching**: Advanced fallback algorithm with typo detection, path structure matching, and keyword analysis
- **404 Count Threshold**: Only create redirects after a path has been encountered multiple times (configurable, default: 4)
- **Bot & Trolling Protection**: Automatically blocks suspicious activity including:
  - Bot/crawler detection (enhanced with more patterns)
  - IP-based rate limiting (blocks IPs hitting 10+ unique 404s per hour)
  - Exploitation pattern detection (wp-admin, .env, SQL injection attempts, etc.)
- **Confidence Scoring**: Each redirect suggestion includes a confidence score (0-100)
- **Configurable Thresholds**: Set different confidence levels (low, medium, high) and auto-approval threshold
- **Asynchronous Processing**: Queue-based processing ensures 404 pages load instantly
- **Admin Interface**: Review all redirect suggestions through a Views-based admin interface
- **Bulk Operations**: Approve or reject multiple redirects at once
- **Auto-Approval**: Automatically create redirects when confidence is high enough and count threshold is met

## Requirements

- Drupal 10 or 11
- [AI Module](https://www.drupal.org/project/ai) (^1.2)
- [Redirect Module](https://www.drupal.org/project/redirect) (^1.6)
- [Views Bulk Operations](https://www.drupal.org/project/views_bulk_operations) (^4.3)
- An AI provider configured in the AI module (OpenAI, Anthropic, etc.)

## Installation

1. Install the module:
   ```bash
   drush en ai_404_redirect -y
   ```

2. Configure an AI provider in the AI module at `/admin/config/ai/models`

3. Configure the module at `/admin/config/search/ai-404-redirect`:
   - Enable the module
   - Select your AI provider
   - Set confidence thresholds
   - Set auto-approval threshold

## Configuration

Access the configuration page at `/admin/config/search/ai-404-redirect`.

### Confidence Thresholds

- **Low Confidence**: Minimum score for low confidence level (default: 50)
- **Medium Confidence**: Minimum score for medium confidence level (default: 70)
- **High Confidence**: Minimum score for high confidence level (default: 85)
- **Auto-Approve Threshold**: Score above which redirects are automatically created (default: 90)

### Redirect Creation Settings

- **Minimum 404 Count**: Number of times a 404 path must be encountered before creating a redirect (default: 4)
  - Prevents creating redirects for one-off typos
  - Set to 1 to create redirects immediately

### Bot & Trolling Protection

- **Enable Bot/Trolling Blocking**: Toggle to enable/disable protection (default: enabled)
- **Suspicious IP Threshold**: Number of unique 404 paths from the same IP within 1 hour that triggers blocking (default: 10)
  - Helps prevent trolling bots from creating spam redirects

### How It Works

1. When a 404 error occurs, the module intercepts it and queues it for asynchronous processing
2. The system checks for suspicious activity:
   - Bot detection (user agent patterns)
   - IP-based rate limiting (too many unique 404s from same IP)
   - Exploitation pattern detection (common attack paths)
3. If not blocked, the AI analyzes:
   - Whether a redirect should be created
   - Which page best matches the 404 URL (using intelligent candidate matching)
   - Confidence level of the match
4. The 404 count is incremented for the path
5. Suggestions are stored in the database
6. High-confidence suggestions are auto-approved when:
   - Confidence score ≥ auto-approve threshold
   - 404 count ≥ minimum count threshold
   - Not from a bot
7. All suggestions can be reviewed in the admin interface

## Admin Interface

Access the redirect suggestions at `/admin/content/ai-404-redirect` (after creating a View).

The interface allows you to:
- View all redirect suggestions
- Filter by status, confidence level, bot requests
- Sort by confidence score, date, etc.
- Approve or reject redirects in bulk
- See AI reasoning for each suggestion

## Creating the Admin View

After installing the module, create a View:

1. Go to `/admin/structure/views/add`
2. View name: "AI 404 Redirect Suggestions"
3. Show: AI 404 Redirect Suggestions
4. Add fields:
   - Source Path
   - Suggested Path
   - Confidence Score
   - Status
   - Created date
   - AI Reasoning
5. Add filters:
   - Status
   - Confidence Score
   - Is Bot
6. Add bulk operations field for approve/reject actions
7. Save the view

## Database Schema

The module creates two tables:

### `ai_404_redirect_suggestions`
- `id`: Unique ID
- `source_path`: The 404 path
- `suggested_path`: Suggested redirect path
- `suggested_node_id`: Node ID of suggested target
- `confidence_score`: AI confidence (0-100)
- `should_redirect`: Whether AI thinks it should redirect
- `is_bot`: Whether request was from a bot
- `user_agent`: User agent string
- `client_ip`: Client IP address (for tracking suspicious activity)
- `404_count`: Number of times this 404 path has been encountered
- `status`: pending, approved, rejected, auto_approved
- `redirect_id`: ID of created redirect entity
- `ai_reasoning`: AI explanation
- `created`: Timestamp
- `updated`: Timestamp

### `ai_404_redirect_alias_index`
Keyword index table for fast alias searching:
- `id`: Unique ID
- `alias`: Path alias
- `path`: System path (e.g., /node/123)
- `node_id`: Node ID
- `keywords`: Space-separated keywords for searching
- `soundex_keywords`: SOUNDEX codes for fuzzy matching
- `path_segments`: JSON-encoded path segments
- `last_segment`: Last segment of path (for matching)
- `first_segment`: First segment of path (for prefix matching)
- `updated`: Timestamp

## Permissions

- **Administer AI 404 Redirect**: Full access to configure and review redirects

## Troubleshooting

### AI Analysis Not Working

- Ensure an AI provider is configured in the AI module
- Check that the provider supports chat operations
- Verify API keys are set correctly
- Check the watchdog logs for errors

### Redirects Not Being Created

- Check the auto-approval threshold setting
- Verify the Redirect module is enabled
- Ensure confidence scores are high enough
- Check that suggested paths exist

## Support

For issues or feature requests, please file an issue in the project repository.


