<?php

/**
 * @file
 * Views integration for AI 404 Redirect.
 */

/**
 * Implements hook_views_data().
 */
function ai_404_redirect_views_data() {
  $data = [];

  // Define the base table.
  $data['ai_404_redirect_suggestions']['table']['group'] = t('AI 404 Redirect');
  $data['ai_404_redirect_suggestions']['table']['base'] = [
    'title' => t('AI 404 Redirect Suggestions'),
    'help' => t('Redirect suggestions generated by AI for 404 errors.'),
    'query_id' => 'ai_404_redirect',
  ];

  // ID field.
  $data['ai_404_redirect_suggestions']['id'] = [
    'title' => t('ID'),
    'help' => t('The unique ID of the suggestion.'),
    'field' => [
      'id' => 'numeric',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'numeric',
    ],
  ];

  // Source path field.
  $data['ai_404_redirect_suggestions']['source_path'] = [
    'title' => t('Source Path'),
    'help' => t('The 404 path that was requested.'),
    'field' => [
      'id' => 'standard',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
  ];

  // Suggested path field.
  $data['ai_404_redirect_suggestions']['suggested_path'] = [
    'title' => t('Suggested Path'),
    'help' => t('The suggested redirect path.'),
    'field' => [
      'id' => 'standard',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
  ];

  // Confidence score field.
  $data['ai_404_redirect_suggestions']['confidence_score'] = [
    'title' => t('Confidence Score'),
    'help' => t('AI confidence score (0-100).'),
    'field' => [
      'id' => 'numeric',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'numeric',
    ],
  ];

  // Status field.
  $data['ai_404_redirect_suggestions']['status'] = [
    'title' => t('Status'),
    'help' => t('Status of the suggestion.'),
    'field' => [
      'id' => 'standard',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'in_operator',
      'options callback' => 'ai_404_redirect_get_status_options',
    ],
  ];

  // Should redirect field.
  $data['ai_404_redirect_suggestions']['should_redirect'] = [
    'title' => t('Should Redirect'),
    'help' => t('Whether AI determined this should be redirected.'),
    'field' => [
      'id' => 'boolean',
    ],
    'filter' => [
      'id' => 'boolean',
    ],
  ];

  // Is bot field.
  $data['ai_404_redirect_suggestions']['is_bot'] = [
    'title' => t('Is Bot'),
    'help' => t('Whether the request was from a bot.'),
    'field' => [
      'id' => 'boolean',
    ],
    'filter' => [
      'id' => 'boolean',
    ],
  ];

  // Created date field.
  $data['ai_404_redirect_suggestions']['created'] = [
    'title' => t('Created'),
    'help' => t('When the suggestion was created.'),
    'field' => [
      'id' => 'date',
    ],
    'sort' => [
      'id' => 'date',
    ],
    'filter' => [
      'id' => 'date',
    ],
  ];

  // AI reasoning field.
  $data['ai_404_redirect_suggestions']['ai_reasoning'] = [
    'title' => t('AI Reasoning'),
    'help' => t('AI reasoning for the suggestion.'),
    'field' => [
      'id' => 'standard',
    ],
  ];

  // 404 count field (using valid PHP key name).
  $data['ai_404_redirect_suggestions']['count_404'] = [
    'title' => t('404 Count'),
    'help' => t('Number of times this 404 path has been encountered.'),
    'field' => [
      'id' => 'numeric',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'numeric',
    ],
    'real_field' => '404_count', // Map to actual database field.
  ];

  // Client IP field.
  $data['ai_404_redirect_suggestions']['client_ip'] = [
    'title' => t('Client IP'),
    'help' => t('IP address of the most recent request.'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
  ];

  // Bulk operations field.
  $data['ai_404_redirect_suggestions']['operations'] = [
    'title' => t('Operations'),
    'help' => t('Bulk operations for redirect suggestions.'),
    'field' => [
      'id' => 'bulk_form',
    ],
  ];

  return $data;
}

/**
 * Returns status options for filter.
 */
function ai_404_redirect_get_status_options() {
  return [
    'pending' => t('Pending'),
    'approved' => t('Approved'),
    'rejected' => t('Rejected'),
    'auto_approved' => t('Auto-Approved'),
  ];
}


