<?php

namespace Drupal\ai_404_redirect\Queue;

use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\ai_404_redirect\Service\AiRedirectAnalyzer;
use Symfony\Component\HttpFoundation\Request;

/**
 * Queue worker for processing 404 redirect analysis.
 */
class Ai404RedirectQueueWorker extends QueueWorkerBase {

  /**
   * {@inheritdoc}
   */
  public function processItem($data) {
    $path = $data['path'] ?? NULL;
    $user_agent = $data['user_agent'] ?? '';
    $client_ip = $data['client_ip'] ?? '';
    
    if (empty($path)) {
      return;
    }
    
    // Create a minimal request object for analysis.
    $request = Request::create($path);
    $request->headers->set('User-Agent', $user_agent);
    // Set client IP if available.
    if (!empty($client_ip)) {
      $request->server->set('REMOTE_ADDR', $client_ip);
    }
    
    // Get the analyzer service and process the 404.
    $analyzer = \Drupal::service('ai_404_redirect.analyzer');
    $analyzer->analyze404($path, $request);
  }

}
