<?php

namespace Drupal\ai_404_redirect\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the AI 404 Redirect Suggestion entity.
 *
 * This is a pseudo-entity for Views integration.
 */
class Ai404RedirectSuggestion extends ContentEntityBase {

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {
    $fields = [];

    $fields['id'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('ID'))
      ->setDescription(t('The ID of the suggestion.'))
      ->setReadOnly(TRUE);

    $fields['source_path'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Source Path'))
      ->setDescription(t('The 404 path.'))
      ->setRequired(TRUE);

    $fields['suggested_path'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Suggested Path'))
      ->setDescription(t('The suggested redirect path.'));

    $fields['confidence_score'] = BaseFieldDefinition::create('float')
      ->setLabel(t('Confidence Score'))
      ->setDescription(t('AI confidence score.'));

    $fields['status'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Status'))
      ->setDescription(t('Status of the suggestion.'));

    return $fields;
  }

}


