# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.2] - 2024-12-19

### Added
- Custom bulk operations field plugin for Views
- processPendingSuggestions() method for cron-based auto-approval processing
- Update hook 8003 to add bulk operations field to existing views
- Full GPL-2.0 license text

### Fixed
- Improved redirect creation logic to prevent duplicate redirects
- Fixed path cleaning in ApproveRedirect action (handles query strings and fragments)
- Added ContainerFactoryPluginInterface to ApproveRedirect plugin

### Changed
- Bulk form plugin ID changed to ai_404_redirect_bulk_form for better namespace isolation
- Enhanced cron processing to automatically create redirects from pending suggestions

## [1.0.1] - 2024-12-19

### Added
- Custom redirect rules feature in settings form
- Rule-based fallback redirects when AI doesn't find a good match
- Wildcard pattern matching support (e.g., `blog* -> /newsroom`)
- Rule parsing with support for comments (lines starting with #)

## [1.0.0] - 2024-12-08

### Added
- Initial release
- AI-powered 404 analysis using Drupal AI module
- Automatic redirect suggestion with confidence scoring
- Bot detection and filtering
- Configurable confidence thresholds (low, medium, high, auto-approve)
- Admin interface via Views
- Bulk approve/reject operations
- Auto-approval of high-confidence redirects
- Asynchronous queue-based processing for performance
- 404 count threshold to prevent one-off typo redirects
- Enhanced bot/trolling protection:
  - IP-based rate limiting (suspicious IP threshold)
  - Exploitation pattern detection (wp-admin, .env, SQL injection, etc.)
  - Enhanced bot user agent detection
- Intelligent candidate matching:
  - Keyword-based alias index for fast searching
  - SOUNDEX fuzzy matching for typos
  - Path structure similarity scoring
  - Last segment prioritization
  - Typo detection using Levenshtein distance
- Comprehensive test suite (unit, kernel, functional tests)
- Client IP tracking for security analysis

### Technical Details
- Requires Drupal 10 or 11
- Requires AI module (^1.2)
- Requires Redirect module (^1.6)
- Requires Views Bulk Operations (^4.3)
- Queue-based processing via Drupal Queue API
- Custom Views query plugin for admin interface
- Database indexing for performance
