<?php

namespace Drupal\ai_404_redirect\Plugin\Action;

use Drupal\Core\Action\ActionBase;
use Drupal\Core\Session\AccountInterface;

/**
 * Rejects a redirect suggestion.
 *
 * @Action(
 *   id = "ai_404_redirect_reject",
 *   label = @Translation("Reject redirect"),
 *   type = "ai_404_redirect_suggestion"
 * )
 */
class RejectRedirect extends ActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($suggestion = NULL) {
    if (!$suggestion) {
      return;
    }

    \Drupal::database()->update('ai_404_redirect_suggestions')
      ->fields([
        'status' => 'rejected',
        'updated' => \Drupal::time()->getRequestTime(),
      ])
      ->condition('id', $suggestion->id)
      ->execute();
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, AccountInterface $account = NULL, $return_as_object = FALSE) {
    return $account->hasPermission('administer ai 404 redirect');
  }

}


