# AI 404 Redirect - Confidence Scoring Tests

This directory contains comprehensive tests for the confidence scoring system in the AI 404 Redirect module.

## Test Files

### 1. Kernel Tests (`src/Kernel/ConfidenceScoringTest.php`)
Integration tests that test the confidence scoring with a real Drupal environment:
- Exact path matches
- Last segment matches
- Typo detection
- Low confidence scenarios
- Auto-approval thresholds
- Bot request handling
- Path structure scoring
- Multiple candidate selection

### 2. Unit Tests (`src/Unit/ConfidenceScoringUnitTest.php`)
Unit tests for individual confidence calculation methods:
- `calculatePathStructureScore()` - Path structure similarity
- `calculateTypoSimilarity()` - Typo detection
- `generateFuzzyVariations()` - Fuzzy matching variations
- Confidence scaling and bounds

### 3. Functional Tests (`src/Functional/ConfidenceScoringFunctionalTest.php`)
End-to-end tests using a real browser:
- Typo confidence in real URLs
- Exact match confidence
- Auto-approval based on threshold

## Running Tests

### Manual Test Script (Quick Check)
Run the manual test script to quickly verify confidence scoring:

```bash
ddev drush ev "require_once DRUPAL_ROOT . '/modules/custom/ai_404_redirect/test_confidence.php';"
```

This will test:
- ✅ Exact path matches
- ✅ Last segment matches (e.g., `/who-we-were/careers` → `/who-we-are/careers`)
- ✅ Typo matches (e.g., `/what-we-offed` → `/what-we-offer`)
- ✅ Confidence scaling (0-100)
- ✅ Low confidence scenarios

### PHPUnit Tests

#### Run all tests:
```bash
ddev exec vendor/bin/phpunit web/modules/custom/ai_404_redirect/tests
```

#### Run specific test class:
```bash
# Kernel tests
ddev exec vendor/bin/phpunit web/modules/custom/ai_404_redirect/tests/src/Kernel/ConfidenceScoringTest.php

# Unit tests
ddev exec vendor/bin/phpunit web/modules/custom/ai_404_redirect/tests/src/Unit/ConfidenceScoringUnitTest.php

# Functional tests
ddev exec vendor/bin/phpunit web/modules/custom/ai_404_redirect/tests/src/Functional/ConfidenceScoringFunctionalTest.php
```

#### Run specific test method:
```bash
ddev exec vendor/bin/phpunit --filter testExactPathMatchConfidence web/modules/custom/ai_404_redirect/tests/src/Kernel/ConfidenceScoringTest.php
```

## Test Scenarios Covered

### High Confidence (80-100)
- ✅ Exact path matches: `/loans/land-01` → `/loans/land`
- ✅ Last segment matches: `/who-we-were/careers` → `/who-we-are/careers`
- ✅ Close typo matches: `/what-we-offed` → `/what-we-offer`

### Medium Confidence (40-79)
- ✅ Partial path matches
- ✅ Keyword matches with some structure similarity

### Low Confidence (0-39)
- ✅ Unrelated paths
- ✅ No matching keywords

### Auto-Approval
- ✅ Tests that confidence >= threshold (default 80) triggers auto-approval
- ✅ Tests that confidence < threshold remains pending

### Edge Cases
- ✅ Bot requests (should not redirect)
- ✅ Empty candidates
- ✅ Confidence bounds (0-100)
- ✅ Multiple candidates (selects best match)

## Expected Confidence Scores

| Scenario | Expected Confidence | Auto-Approved? |
|----------|---------------------|----------------|
| Exact match (`/loans/land-01` → `/loans/land`) | 80-100 | ✅ Yes |
| Last segment match (`/who-we-were/careers` → `/who-we-are/careers`) | 80-100 | ✅ Yes |
| Typo match (`/what-we-offed` → `/what-we-offer`) | 60-100 | ✅ Yes (if ≥80) |
| Partial match | 40-79 | ❌ No |
| Unrelated path | 0-39 | ❌ No |
| Bot request | 0 | ❌ No |

## Debugging Failed Tests

If a test fails, check:

1. **Confidence too low**: The matching algorithm may need adjustment
2. **Wrong path suggested**: Check if candidates are being prioritized correctly
3. **Auto-approval not working**: Verify threshold configuration

You can also run the manual test script to see detailed output:

```bash
ddev drush ev "require_once DRUPAL_ROOT . '/modules/custom/ai_404_redirect/test_confidence.php';"
```

This shows:
- Actual confidence scores
- Suggested paths
- Reasoning for each match
- Pass/fail status for each test
