<?php
namespace Drupal\ai_accessibility\Plugin\Editor;

use Drupal\ckeditor5\Plugin\CKEditor5PluginDefault;
use Drupal\editor\EditorInterface;

/**
 * Provides the AI Accessibility CKEditor5 plugin.
 *
 * @CKEditor5Plugin(
*   id = "ai_accessibility_ai_a11y",
*   ckeditor5 = @CKEditor5AspectsOfCKEditor5Plugin(
*     plugins = {"aiAccessibility.AIA11y"},
 *   ),
 *   drupal = @DrupalAspectsOfCKEditor5Plugin(
 *     label = @Translation("AI Accessibility"),
 *     module = "ai_accessibility",
 *     library = "ai_accessibility/editor_integration",
 *   )
 * )
 */
class AIAccessibility extends CKEditor5PluginDefault {
  /**
   * {@inheritdoc}
   */
  public function getDynamicPluginConfig(array $static_plugin_config, EditorInterface $editor): array {
    // In Drupal 11, CKEditor5 is bundled in core. Provide the static plugin
    // configuration that will be merged into the editor configuration.
    return [
  // The plugin must be loaded by its exported package/class name as
  // declared in the module's `ai_accessibility.ckeditor5.yml` file and
  // the JS export (window.CKEditor5.aiAccessibility.AIA11y).
  'plugins' => ['aiAccessibility.AIA11y'],
  // The toolbar button id is different from the plugin package name.
  'toolbar' => ['aiA11y'],
    ];
  }
}
