<?php
namespace Drupal\ai_accessibility\Service;

use Drupal\Core\Config\ConfigFactoryInterface;
use Psr\Log\LoggerInterface;

class AIService {
  protected $httpClient;
  protected $configFactory;

  public function __construct($http_client, ConfigFactoryInterface $config_factory) {
    $this->httpClient = $http_client;
    $this->configFactory = $config_factory;
  }

  /**
   * Route the request to the configured provider. Returns suggestions array.
   */
  public function getSuggestions(string $issue_id, string $html = '') {
    $config = $this->configFactory->get('ai_accessibility.settings');
    $provider = $config->get('provider') ?: 'mock';

    if ($provider === 'openai') {
      $openai = new \Drupal\ai_accessibility\Provider\OpenAIProvider($this->httpClient, $this->configFactory);
      return $openai->suggest($issue_id, $html);
    }

    // Fallback to simple mock.
    if ($issue_id === 'img-alt-1') {
      return [[ 'text' => 'Logo oficial de Drupal 10 en color azul', 'action' => 'set_alt' ]];
    }

  return [[ 'text' => 'Generic accessibility suggestion', 'action' => 'none' ]];
  }
}
