<?php
namespace Drupal\ai_accessibility\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class ValidateController {
  public function validate(Request $request) {
    // MVP mock response: return example violations.
    $violations = [
      [
        'id' => 'img-alt-1',
        'impact' => 'serious',
        'description' => 'Image elements must have alternate text',
        'selector' => 'img[src="drupal.png"]',
        'help' => 'Images should have an alt attribute describing the image.'
      ],
      [
        'id' => 'low-contrast-1',
        'impact' => 'moderate',
        'description' => 'Text elements must have sufficient color contrast',
        'selector' => '.content p',
        'help' => 'Contrast ratio is below WCAG AA for normal text.'
      ]
    ];

    return new JsonResponse(['violations' => $violations]);
  }
}
