// Simple CKEditor5 plugin that adds a toolbar button and a panel to run accessibility checks.
( function () {
  class AIA11yPlugin {
    constructor( editor ) {
      this.editor = editor;
    }

    init() {
      const editor = this.editor;
      const t = editor.t;

      // Add a toolbar button.
      editor.ui.componentFactory.add( 'aiA11y', locale => {
        const view = new window.CKEditor5.ui.button.ButtonView( locale );
        view.set( {
          label: t( 'AI A11y' ),
          withText: true,
        } );

        view.on( 'execute', () => {
          // When clicked, open a simple balloon panel with validation results.
          // Use global window to call the module's validation logic if present.
          if (window.aiA11y && typeof window.aiA11y.openPanel === 'function') {
            window.aiA11y.openPanel(editor);
          }
          else {
            // fallback: run axe on editable element
            alert('AI A11y: open panel (fallback)');
          }
        } );

        return view;
      } );
    }
  }

  // Export plugin under the CKEditor5 package namespace so Drupal/CKEditor can
  // load it using the '{package.Class}' notation (eg. 'aiAccessibility.AIA11y').
  window.CKEditor5 = window.CKEditor5 || {};
  window.CKEditor5.aiAccessibility = window.CKEditor5.aiAccessibility || {};
  window.CKEditor5.aiAccessibility.AIA11y = AIA11yPlugin;
})();
