<?php
namespace Drupal\ai_accessibility\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\ai_accessibility\Service\AIService;

class AIController {
  protected $aiService;

  public function __construct(?AIService $ai_service = NULL) {
    $this->aiService = $ai_service;
  }

  public function suggest(Request $request) {
    $data = json_decode($request->getContent(), TRUE) ?: [];
    $issue_id = $data['issue_id'] ?? NULL;
    $html = $data['html'] ?? '';

    if ($this->aiService) {
      $suggestions = $this->aiService->getSuggestions($issue_id, $html);
      return new JsonResponse(['suggestions' => $suggestions]);
    }

    // Fallback mock
  return new JsonResponse(['suggestions' => [[ 'text' => 'Generic suggestion (fallback)', 'action' => 'none' ]]]);
  }
}
