<?php
namespace Drupal\ai_accessibility\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class AdminSettingsForm extends ConfigFormBase {
  public function getFormId() {
    return 'ai_accessibility_settings';
  }

  protected function getEditableConfigNames() {
    return ['ai_accessibility.settings'];
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('ai_accessibility.settings');

    $form['provider'] = [
      '#type' => 'select',
      '#title' => $this->t('AI Provider'),
      '#options' => [
        'mock' => $this->t('Mock (no external API)'),
        'openai' => $this->t('OpenAI'),
      ],
      '#default_value' => $config->get('provider') ?: 'mock',
    ];

    $form['language'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Default language'),
      '#default_value' => $config->get('language') ?: 'es',
    ];

    $form['api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('AI API Key'),
      '#description' => $this->t('Clave para proveedor AI (p.ej. OpenAI). Guardar de forma segura. For testing you can leave empty to use mock.'),
      '#default_value' => $config->get('api_key') ?: '',
    ];

    return parent::buildForm($form, $form_state) + $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('ai_accessibility.settings')
  ->set('provider', $form_state->getValue('provider'))
  ->set('language', $form_state->getValue('language'))
  ->set('api_key', $form_state->getValue('api_key'))
  ->save();

    parent::submitForm($form, $form_state);
  }
}
