(function ($, Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.altTextLabGenerator = {
    processedFiles: {},

    attach: function (context, settings) {
      var config = settings.alt_text_lab || drupalSettings.alt_text_lab;
      if (!config || !config.files) {
        return;
      }

      $.each(config.files, function (fileId, fileData) {
        // Skip if already processed.
        if (Drupal.behaviors.altTextLabGenerator.processedFiles[fileId]) {
          return;
        }

        var widget = $(context)
          .find('input[type="hidden"][name$="[fids]"][value="' + fileId + '"]')
          .closest('.js-form-managed-file, .form-managed-file');

        if (!widget.length) {
          return;
        }

        var altInput = widget.find('input[name*="[alt]"]');
        if (!altInput.length) {
          return;
        }

        Drupal.behaviors.altTextLabGenerator.processedFiles[fileId] = true;

        var container = altInput.closest('.js-form-item, .form-item');

        var throbber = $('<div class="ajax-progress ajax-progress--throbber"><div class="ajax-progress__throbber">&nbsp;</div><div class="ajax-progress__message">' + Drupal.t('Generating alt text...') + '</div></div>');
        container.append(throbber);

        altInput.prop('disabled', true);

        var url = (drupalSettings.path.baseUrl || '/') + 'alt-text-lab/generate/' + fileId;

        $.ajax({
          url: url,
          method: 'GET',
          dataType: 'json',
          timeout: 30000,
          success: function (response) {
            if (response.alt_text) {
              altInput.val(response.alt_text).trigger('change');

              // Store history_id in hidden field for form submission.
              var historyIdField = widget.find('input.alt-text-lab-history-id');
              if (historyIdField.length && response.history_id) {
                historyIdField.val(response.history_id);
              }
            }
            cleanup();
          },
          error: function (xhr, status, error) {
            console.error('AltTextLab generation error:', xhr.responseJSON || error);
            cleanup();
          }
        });

        function cleanup() {
          throbber.remove();
          altInput.prop('disabled', false);
        }
      });
    }
  };

})(jQuery, Drupal, drupalSettings);
