(function (Drupal) {
  'use strict';

  Drupal.behaviors.altTextLabBulk = {
    attach: function (context) {
      var forms = context.querySelectorAll('.alt-text-lab-bulk-form');
      if (!forms.length) {
        return;
      }

      forms.forEach(function (form) {
        if (form.dataset.altTextLabBulkInitialized) {
          return;
        }
        form.dataset.altTextLabBulkInitialized = 'true';

        var checkbox = form.querySelector('input[name="overwrite"]');
        var button = form.querySelector('button.button--primary');
        var info = form.closest('.alt-text-lab-bulk-wrapper') || document;
        info = info.querySelector('.alt-text-lab-bulk-info');

        var total = parseInt(form.getAttribute('data-total') || '0', 10);
        var withoutAlt = parseInt(form.getAttribute('data-without-alt') || '0', 10);

        function update() {
          var targetCount = checkbox && checkbox.checked ? total : withoutAlt;

          if (info) {
            if (checkbox && checkbox.checked) {
              info.textContent = Drupal.t('Alt text will be generated for @count images (including ones that already have alt text).', {
                '@count': targetCount
              });
            } else {
              info.textContent = Drupal.t('Alt text will be generated only for @count images without alt text.', {
                '@count': targetCount
              });
            }
          }

          if (button) {
            if (targetCount === 0) {
              button.disabled = true;
            } else {
              button.disabled = false;
            }
          }
        }

        update();
        if (checkbox) {
          checkbox.addEventListener('change', update);
        }
      });
    }
  };
})(Drupal);








