/**
 * Auto-refresh AltTextLab bulk generation history table.
 */
(function (Drupal, drupalSettings) {
  'use strict';

  function getBulkRows() {
    var rows = document.querySelectorAll('tr.alt-text-lab-bulk-row');
    var ids = [];

    rows.forEach(function (row) {
      var total = parseInt(row.getAttribute('data-total') || '0', 10);
      var completed = parseInt(row.getAttribute('data-completed') || '0', 10);
      if (total > 0 && completed < total) {
        var id = parseInt(row.getAttribute('data-bulk-id') || '0', 10);
        if (id) {
          ids.push(id);
        }
      }
    });

    return ids;
  }

  function updateRows(data) {
    if (!Array.isArray(data)) {
      return;
    }

    data.forEach(function (item) {
      var row = document.querySelector('tr.alt-text-lab-bulk-row[data-bulk-id="' + item.id + '"]');
      if (!row) {
        return;
      }

      var completed = item.successfulCount + item.failedCount;
      var total = item.count_total || item.countTotal || 0;
      var percent = total > 0 ? Math.round((completed / total) * 100) : 100;

      row.setAttribute('data-completed', completed.toString());

      var cells = row.querySelectorAll('td');

      if (cells.length >= 7) {
        cells[2].textContent = completed + '/' + total + ' (' + percent + '%)';

        var progressCell = cells[3];
        var progressEl = progressCell.querySelector('progress');
        if (progressEl) {
          progressEl.value = completed;
          progressEl.max = total || 1;
        }
        var labelEl = progressCell.querySelector('.alt-text-lab-progress-label');
        if (labelEl) {
          labelEl.textContent = percent + '%';
        }

        var successCell = cells[4];
        if (item.successfulCount > 0) {
          successCell.innerHTML =
            '<a href="/admin/reports/alt-text-lab/history?bulk_id=' +
            item.id +
            '">' +
            item.successfulCount +
            '</a>';
        }
        else {
          successCell.textContent = item.successfulCount.toString();
        }

        var failedCell = cells[5];
        if (item.failedCount > 0) {
          failedCell.innerHTML =
            '<a href="/admin/reports/alt-text-lab/history/failed?bulk_id=' +
            item.id +
            '">' +
            item.failedCount +
            '</a>';
        }
        else {
          failedCell.textContent = item.failedCount.toString();
        }
      }
    });
  }

  function tick() {
    var ids = getBulkRows();
    if (!ids.length) {
      return;
    }

    var url = '/admin/reports/alt-text-lab/history/bulk/status';

    fetch(url, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'X-Requested-With': 'XMLHttpRequest'
      },
      body: JSON.stringify({ ids: ids })
    })
      .then(function (response) {
        if (!response.ok) {
          throw new Error('HTTP ' + response.status);
        }
        return response.json();
      })
      .then(function (payload) {
        if (payload && payload.success) {
          updateRows(payload.data || []);
        }
      })
      .catch(function () {
         console.error('[AltTextLab bulk] Status request failed', e);
      });
  }

  if (!drupalSettings.alt_text_lab) {
    drupalSettings.alt_text_lab = {};
  }
  if (!drupalSettings.alt_text_lab.bulkHistoryStarted) {
    drupalSettings.alt_text_lab.bulkHistoryStarted = true;
    setInterval(tick, 5000);
  }

})(Drupal, drupalSettings);


