<?php

namespace Drupal\alt_text_lab\Config;

/**
 * AltTextLab external URLs.
 */
class AltTextLabUrls {

  private const BASE_APP = 'https://app.alttextlab.com';
  private const BASE_API_URL = 'https://app.alttextlab.com/api';

  /**
   * Get base API URL.
   */
  public static function baseApiUrl(): string {
    return self::BASE_API_URL;
  }

  public static function apiKeysBase(): string {
    return self::BASE_APP . '/settings/api-keys';
  }

  public static function apiKeysHint(): string {
    return self::apiKeysBase() . '?utm_medium=integration&utm_source=drupal&utm_campaign=internal_use&utm_content=api-key-hint';
  }

  public static function apiKeysInvalid(): string {
    return self::apiKeysBase() . '?utm_medium=integration&utm_source=drupal&utm_campaign=internal_use&utm_content=invalid_api_key';
  }

  public static function subscriptionDashboard(): string {
    return self::BASE_APP . '/settings/subscription?utm_medium=integration&utm_source=drupal&utm_campaign=internal_use&utm_content=dashboard_page';
  }

}













