<?php

namespace Drupal\alt_text_lab\Plugin\Action;

use Drupal\Core\Action\ActionBase;
use Drupal\Core\Annotation\Action;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\TempStore\PrivateTempStoreFactory;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Redirects to bulk generation page for selected media.
 *
 * @Action(
 *   id = "alt_text_lab_bulk_generate",
 *   label = @Translation("Generate alt text (AltTextLab)"),
 *   type = "media",
 *   confirm_form_route_name = "alt_text_lab.bulk_selection"
 * )
 */
class BulkGenerateAltText extends ActionBase implements ContainerFactoryPluginInterface {

  protected $tempStoreFactory;

  public function __construct(array $configuration, $plugin_id, $plugin_definition, PrivateTempStoreFactory $temp_store_factory) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->tempStoreFactory = $temp_store_factory;
  }

  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('tempstore.private')
    );
  }

  public function executeMultiple(array $entities) {
    $info = [];
    foreach ($entities as $entity) {
      $info[$entity->id()] = $entity->id();
    }
    $tempstore = $this->tempStoreFactory->get('alt_text_lab_bulk_selection');
    $tempstore->set('media_ids', $info);
  }

  public function execute($entity = NULL) {
    $this->executeMultiple([$entity]);
  }

  public function access($object, ?AccountInterface $account = NULL, $return_as_object = FALSE) {
    return $object->access('update', $account, $return_as_object);
  }

}

