<?php

namespace Drupal\alt_text_lab\Service;

use Drupal\Core\Database\Connection;
use Drupal\Component\Datetime\TimeInterface;

/**
 * Service for logging alt text generation failures.
 */
class AltTextLabLogger {

  protected Connection $database;

  protected TimeInterface $time;

  public function __construct(Connection $database, TimeInterface $time) {
    $this->database = $database;
    $this->time = $time;
  }

  /**
   * Log a failed generation attempt.
   */
  public function logFailure(int $fid, string $message, int $bulk_id = 0, int $media_id = 0, string $field_name = '', int $delta = 0): void {
    try {
      $this->database->insert('alt_text_lab_log')
        ->fields([
          'fid' => $fid,
          'media_id' => $media_id,
          'field_name' => $field_name !== '' ? $field_name : NULL,
          'delta' => $delta,
          'message' => $message,
          'created' => $this->time->getRequestTime(),
          'bulk_id' => $bulk_id,
        ])
        ->execute();
    }
    catch (\Exception $e) {
      \Drupal::logger('alt_text_lab')->error('Failed to log failure to database: @message', [
        '@message' => $e->getMessage(),
        'fid' => $fid,
        'bulk_id' => $bulk_id,
      ]);
    }
  }

}

