
# AI Automator Extractor

## What is this
This module helps you do normal extraction tasks that you would usually use regular expression and code to solve, inside your AI Automator workflow. This is a submodule from the [AI module](https://www.drupal.org/project/ai) that allows you to automate almost anything.

This means that if you for instance are scraping a website and you want to extract all images from a scraped webpage into image fields, there is an Automator for it.

It also offers you to use regular expressions to scrape or even count instances of some pattern inside any type of text field.

Note that this makes the AI Interpolator Extractor obsolute for Drupal 10.3+.

For more information on how to use the AI Automator (previously AI Interpolator), check https://workflows-of-ai.com.

## Requirements
* To use it, you need to use a third party module using the service. Currently its only usable with the AI Automator submodule of the [AI module](https://www.drupal.org/project/ai)

## Features
* Extract images according to your settings from HTML.
* Extract files according to your settings from HTML.
* Extract links from unstructured text.
* Extract e-mails from unstructured text.
* Fill an integer field with how many times a regex on a text field exists.
* Extract text from unstructured text fields into text fields.

## How to use as AI Automator type (link extraction example)
1. Install the [AI module](https://www.drupal.org/project/ai).
2. Install this module.
3. Create some entity or node type with a text long field.
4. Create a link.
5. Enable AI Automator checkbox and configure it.
6. Create an entity of the type you generated, fill in the text field with some HTML with links and save.
7. The links should be populated in the link field.

## Sponsors
This module was supported by [FreelyGive](https://freelygive.io/), your partner in Drupal AI.
