# AI Chat

## Introduction
AI Chat is a Drupal 11 module that adds a floating AI-powered chat widget to the bottom-right of your site’s pages. It leverages the ai_assistant_api module to provide conversational AI capabilities to users with selected roles.

## Requirements
- Drupal 11.1.6 or higher
- AI Assistant API module (part of [AI Agents](https://www.drupal.org/project/ai_agents))
- User module (core)

## Installation
1. Download and install the module using Composer:
   ```sh
   composer require drupal/ai_chat
   ```
2. Enable the module via Drush or the Drupal admin interface.

## Configuration
1. Go to `admin/config/ai/ai-assistant` and Create an assistant if you haven't already.
2. Go to `/admin/config/ai/ai-chat`.
3. Configure which user roles can access the AI chat widget and adjust other available settings.
4. Click "Save configuration."
5. The AI chat widget will now appear for users with the selected roles on the bottom-right of the site.

## How It Works
AI Chat injects a floating chat widget into the site interface for authorized users. All chat interactions are handled via AJAX and routed through the ai_assistant_api, ensuring real-time, AI-powered responses. The module is configurable to restrict access by user role and integrates seamlessly with your site’s content.

## Maintainers
- Yorick Devleeschouwer - [yorickdv](https://drupal.org/u/yorickdv)

## License
This project is licensed under the GNU General Public License v2.0 or later.
