# AI Checklist

The AI Checklist module provides a comprehensive checklist for tracking the setup and configuration of AI-related modules in DXPR CMS.

## Description

This module helps administrators and site builders track the installation and configuration progress of AI features included in the DXPR CMS AI recipe. It provides a visual checklist interface that automatically detects installed modules and guides users through the complete AI setup process.

## Requirements

This module requires:
- Drupal 8.8, 9, 10, or 11
- [Checklist API](https://www.drupal.org/project/checklistapi)

## Installation

Install as you would normally install a contributed Drupal module:

```bash
composer require drupal/checklistapi
drush en ai_checklist
```

## Usage

1. Navigate to `/admin/config/ai/ai-checklist` or find "AI Checklist" in the Development configuration section
2. The checklist will automatically detect which AI modules are already installed
3. Work through each section, checking off completed tasks as you go
4. Click "Save" to save your progress

## Checklist Sections

### Initial Setup
- Obtaining DXPR API Key
- Installing core AI modules
- Configuring API authentication

### AI Image Features  
- AI-powered alt text generation
- Image optimization settings

### AI Content Features
- AI Agents for content assistance
- Content strategy recommendations
- CKEditor AI integration

### Content Analysis
- Brand voice analysis
- Sentiment analysis
- Content metrics and insights

### Supporting Tools
- Markdown conversion utilities
- Path-based processing

### Privacy and Permissions
- Consent management setup
- Role-based permissions
- Feature testing

## Features

- **Auto-detection**: Automatically marks installed modules as complete
- **Direct links**: Quick access to module download, installation, and configuration pages
- **CLI commands**: Shows composer commands for each module
- **Progress tracking**: Save your checklist progress at any time
- **Permission-aware**: Only shows links users have access to

## Support

For issues related to this module, please use the issue queue on drupal.org.

For AI feature support and API keys, visit [DXPR.com](https://dxpr.com).

## Maintainers

This module is maintained as part of the DXPR CMS distribution.