# AI Console

A Drupal module that provides a Minecraft/Counter-Strike style console overlay for interacting with AI assistants using a keyboard shortcut.

## Features

- Quick-access console triggered by keyboard shortcut (default: `)
- Real-time AI chat interface
- Conversation history persistence
- Configurable page visibility
- Customizable placeholder text
- Automatic history cleanup via cron
- Multi-language support

## Requirements

- Drupal 9.x or 10.x
- AI Assistant API module (`ai_assistant_api`)
- An AI assistant configured in the AI Assistant API module

## Installation

1. Download and install the module:
   ```bash
   composer require drupal/ai_console
   drush en ai_console
   ```

2. Configure the module at `/admin/config/ai/ai_console`:
   - Select an AI assistant
   - Set your preferred keyboard shortcut
   - Configure placeholder text
   - Set history retention period
   - Configure page visibility settings

3. Clear cache:
   ```bash
   drush cr
   ```

## Configuration

### AI Assistant
Select which AI assistant to use for the console. This requires the AI Assistant API module to be installed and at least one assistant to be configured.

### Keyboard Shortcut
Configure the keyboard shortcut to open the console. Examples:
- Single key: `` ` ``, `~`
- With modifiers: `Ctrl+Space`, `Alt+A`, `Shift+C`

### Placeholder Text
Customize the placeholder text shown in the input field. Default: "Ask your question here"

### History Retention
Set how many days to keep conversation history. Set to 0 to keep history forever. Old entries are automatically deleted by cron.

### Page Visibility
Configure which pages should show or hide the console:
- **Show for the listed pages**: Console only appears on specified pages
- **Hide for the listed pages**: Console appears everywhere except specified pages

Use wildcards for pattern matching:
- `/user/*` - All user pages
- `/admin/*` - All admin pages
- `<front>` - Front page only

## Usage

1. Press your configured keyboard shortcut (default: `) to open the console
2. Type your question or command
3. Press Enter to send (Shift+Enter for new line)
4. View AI responses in real-time
5. Press Escape or click outside to close

## Database Schema

The module creates a `ai_console_log` table to store conversation history:
- `id`: Auto-increment primary key
- `uid`: User ID
- `prompt`: User's input message
- `output`: AI's response
- `timestamp`: When the conversation occurred

## Permissions

- **administer site configuration**: Required to access settings form
- **access content**: Required to use the console and view history

## Hooks Implemented

### hook_help()
Provides help text on the module's help page.

### hook_page_attachments()
Attaches the console library and settings to pages based on visibility configuration.

### hook_cron()
Automatically deletes old conversation history based on retention settings.

## API Endpoints

### POST /ai-console/send
Send a message to the AI assistant.

**Request body:**
```json
{
  "message": "Your question here",
  "assistant": "assistant_id"
}
```

**Response:**
```json
{
  "response": "AI response here"
}
```

### GET /ai-console/history
Retrieve conversation history for the current user.

**Response:**
```json
{
  "success": true,
  "messages": [
    {
      "prompt": "User question",
      "output": "AI response"
    }
  ]
}
```

## Development

### File Structure
```
ai_console/
├── ai_console.info.yml          # Module metadata
├── ai_console.module            # Module hooks
├── ai_console.routing.yml       # Route definitions
├── ai_console.libraries.yml     # Asset libraries
├── ai_console.install           # Install/uninstall hooks
├── config/
│   └── install/
│       └── ai_console.settings.yml  # Default configuration
├── src/
│   ├── Controller/
│   │   └── AiConsoleController.php  # API endpoints
│   └── Form/
│       └── AiConsoleSettingsForm.php  # Settings form
├── js/
│   └── ai_console.js            # Frontend JavaScript
└── css/
    └── ai_console.css           # Styling

```

### JavaScript Events

The console is implemented as a Drupal behavior and listens for:
- Keyboard shortcuts for opening/closing
- Form submission for sending messages
- Escape key for closing
- Click outside overlay for closing

### Adding Custom Functionality

To extend the module, you can:

1. **Hook into the controller**: Override or extend `AiConsoleController` to modify request/response handling
2. **Alter the console HTML**: Modify `ai_console.js` to customize the UI
3. **Add custom CSS**: Create a sub-theme and override `ai_console.css`
4. **Implement hook_page_attachments_alter()**: Modify when/how the console is loaded

### Testing

After making changes:

1. Clear Drupal cache:
   ```bash
   drush cr
   ```

2. Test the console:
   - Open a page where the console should appear
   - Press your keyboard shortcut
   - Send a test message
   - Check browser console for JavaScript errors

3. Test configuration:
   - Visit `/admin/config/ai/ai_console`
   - Modify settings
   - Verify changes take effect

## Troubleshooting

### Console doesn't appear
- Check page visibility settings
- Verify user has "access content" permission
- Clear Drupal cache
- Check browser console for JavaScript errors

### Keyboard shortcut not working
- Verify the shortcut isn't conflicting with browser/OS shortcuts
- Check if focus is in an input field (shortcut won't work)
- Try a different shortcut combination

### AI not responding
- Verify AI Assistant API module is installed and configured
- Check that an assistant is selected in settings
- Review error logs: `drush watchdog:show`
- Check network tab in browser dev tools for API errors

### History not loading
- Verify database table `ai_console_log` exists
- Check user has messages in the database
- Review browser console for JavaScript errors

## Contributing

Contributions are welcome! Please follow Drupal coding standards and test your changes thoroughly.

## License

GPL-2.0-or-later

## Credits

Adapted from Mautic AI Console.
