<?php

namespace Drupal\ai_content_advisor;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;
use Drupal\Core\Url;

/**
 * Defines a class to build a listing of AI Content Advisor Report entities.
 *
 * @ingroup ai_content_advisor
 */
class AiContentAdvisorReportListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['id'] = $this->t('ID');
    $header['report_type'] = $this->t('Report Type');
    $header['entity_info'] = $this->t('Analyzed Content');
    $header['author'] = $this->t('Author');
    $header['created'] = $this->t('Created');
    $header['feedback_rating'] = $this->t('Feedback Rating');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var \Drupal\ai_content_advisor\Entity\AiContentAdvisorReport $entity */
    $row['id'] = $entity->id();
    $row['report_type'] = $entity->get('report_type')->value;
    
    // Build entity info display.
    $entity_type_id = $entity->get('entity_type_id')->value;
    $entity_id = $entity->get('entity_id')->value;
    $entity_info = '';
    if ($entity_type_id && $entity_id) {
      try {
        $analyzed_entity = \Drupal::entityTypeManager()->getStorage($entity_type_id)->load($entity_id);
        if ($analyzed_entity && $analyzed_entity->hasLinkTemplate('canonical')) {
          $entity_info = Link::fromTextAndUrl(
            $analyzed_entity->label() ?: $this->t('Untitled'),
            $analyzed_entity->toUrl()
          )->toString();
        } else {
          $entity_info = $this->t('@type: @id', [
            '@type' => $entity_type_id,
            '@id' => $entity_id,
          ]);
        }
      } catch (\Exception $e) {
        $entity_info = $this->t('@type: @id', [
          '@type' => $entity_type_id,
          '@id' => $entity_id,
        ]);
      }
    }
    $row['entity_info'] = $entity_info;
    
    $row['author'] = $entity->getOwner()->getDisplayName();
    $row['created'] = \Drupal::service('date.formatter')->format($entity->get('created')->value);
    
    $feedback_rating = $entity->get('feedback_quality_rating')->value;
    $row['feedback_rating'] = $feedback_rating ? ucfirst(str_replace('_', ' ', $feedback_rating)) : $this->t('No feedback');
    
    return $row + parent::buildRow($entity);
  }

}