<?php

declare(strict_types=1);

namespace Drupal\ai_context\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Edit form for Global AI Context.
 */
final class AiContextGlobalForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['ai_context.global_context'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'ai_context_global_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('ai_context.global_context');

    $form['description'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Description'),
      '#default_value' => $config->get('description') ?? '',
      '#rows' => 3,
      '#description' => $this->t("Brief description of this global context's purpose. Used for admin reference only."),
    ];

    $form['content'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Content (Markdown allowed)'),
      '#default_value' => $config->get('content') ?? '',
      '#rows' => 12,
      '#description' => $this->t('Global site-wide context that will always be included for all AI agents.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('ai_context.global_context')
      ->set('description', $form_state->getValue('description'))
      ->set('content', $form_state->getValue('content'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
