<?php

declare(strict_types=1);

namespace Drupal\ai_document_ocr\OperationType\DocumentToText;

use Drupal\ai\OperationType\OperationTypeInterface;

/**
 * Interface for Document to Text operations (OCR/Document Processing).
 */
interface DocumentToTextInterface extends OperationTypeInterface {

  /**
   * Converts a document to text using OCR.
   *
   * @param string|DocumentToTextInput $input
   *   The input document data or DocumentToTextInput object.
   * @param string $model_id
   *   The model ID to use for OCR processing.
   * @param array $tags
   *   Additional tags for processing.
   *
   * @return DocumentToTextOutput
   *   The OCR output containing extracted text and metadata.
   *
   * @throws \Drupal\ai\Exception\AiBadRequestException
   *   If the request is invalid or processing fails.
   */
  public function documentToText(string|DocumentToTextInput $input, string $model_id, array $tags = []): DocumentToTextOutput;

}
