<?php

declare(strict_types=1);

namespace Drupal\ai_document_ocr\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * AI module hook implementations for AI Document OCR module.
 */
class AiHooks {

  /**
   * Implements hook_ai_operationtype_alter().
   */
  #[Hook('ai_operationtype_alter')]
  public function aiOperationtypeAlter(array &$definitions): void {
    // Add our DocumentToText operation type.
    $definitions['document_to_text'] = [
      'id' => 'document_to_text',
      'label' => new TranslatableMarkup('Document to Text'),
      'class' => 'Drupal\\ai_document_ocr\\Plugin\\OperationType\\DocumentToTextPlugin',
      'interface_class' => 'Drupal\\ai_document_ocr\\OperationType\\DocumentToText\\DocumentToTextInterface',
      'actual_type' => 'document_to_text',
      'filter' => [],
    ];
  }

}
