<?php

declare(strict_types=1);

namespace Drupal\ai_document_ocr\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Url;

/**
 * System hook implementations for AI Document OCR module.
 */
class SystemHooks {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help(string $route_name, RouteMatchInterface $route_match): string {
    switch ($route_name) {
      case 'help.page.ai_document_ocr':
        $output = '';
        $output .= '<h3>' . $this->t('About') . '</h3>';
        $output .= '<p>' . $this->t('The AI Document OCR module integrates Google Document AI OCR capabilities with the AI module, allowing you to extract text and structured data from PDF files, images, and other supported document formats.') . '</p>';
        $output .= '<h3>' . $this->t('Configuration') . '</h3>';
        $output .= '<p>' . $this->t('To configure the module:') . '</p>';
        $output .= '<ol>';
        $output .= '<li>' . $this->t('Set up a Google Cloud Project and enable the Document AI API.') . '</li>';
        $output .= '<li>' . $this->t('Create a Document AI processor in your Google Cloud Console.') . '</li>';
        $output .= '<li>' . $this->t('Generate a service account key with the necessary permissions.') . '</li>';
        $output .= '<li>' . $this->t('Configure the module at <a href=":url">AI Document OCR Provider</a>.', [':url' => Url::fromRoute('ai_document_ocr.ai_provider')->toString()]) . '</li>';
        $output .= '</ol>';
        $output .= '<h3>' . $this->t('Usage') . '</h3>';
        $output .= '<p>' . $this->t("Once configured, you can use the OCR functionality through the AI module's provider system.") . '</p>';
        $output .= '<h3>' . $this->t('Supported File Formats') . '</h3>';
        $output .= '<p>' . $this->t('The module supports the following file formats:') . '</p>';
        $output .= '<ul>';
        $output .= '<li>' . $this->t('PDF documents') . '</li>';
        $output .= '<li>' . $this->t('JPEG, PNG, GIF images') . '</li>';
        $output .= '<li>' . $this->t('TIFF, BMP, WebP images') . '</li>';
        $output .= '</ul>';
        return $output;
    }
    return '';
  }

}
