<?php

declare(strict_types=1);

namespace Drupal\ai_document_ocr\Plugin\OperationType;

use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\ai\Attribute\OperationType;

/**
 * Plugin implementation for Document to Text operation type.
 */
#[OperationType(
  id: 'document_to_text',
  label: new TranslatableMarkup('Document to Text'),
)]
class DocumentToTextPlugin extends PluginBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function getOperationType(): string {
    return 'document_to_text';
  }

  /**
   * {@inheritdoc}
   */
  public function getDefinition(): array {
    return [
      'id' => 'document_to_text',
      'label' => $this->t('Document to Text'),
      'description' => $this->t('Converts documents (images, PDFs) to text using OCR technology'),
      'supported_formats' => [
        'application/pdf',
        'image/jpeg',
        'image/png',
        'image/gif',
        'image/tiff',
        'image/bmp',
        'image/webp',
      ],
    ];
  }

}
