# AI Deep Reference

**What is this?** This module adds a "deep reference" to existing tokens.
Whenever you use a token, it will find the token's description and offer it as
an additional token.

## Requirements

Even though this module is intended for use in the AI ecosystem, the AI module
is not strictly required.

The Token module is required.

## Usage

Just install & enable the module according to the standard instructions (ie.
composer).  There is no config page for this module, you can just use it
wherever tokens are used.

### Example

**Prerequisites:**

- A taxonomy vocabulary "Colors" with terms "Red", "Green", "Blue"
- A node type "Book" with a field "Color" that references the "Colors" vocabulary

**Usage:**

- [node:field_color] will return "Red"
- [node:field_color:entity:description] will return "The color of fire and blood"

**Advanced example:**

This is a prompt to combine different taxonomy terms into a single scene,
which can be illustrated by AI.  Note the scene can support multiple characters.

```text
You are an illustrating robot, and you need to illustrate a scene from a Dungeons & Dragons adventure.

Setting: [node:field_scene], [node:field_scene:entity:description]

Characters: [node:field_characters]:
- [node:field_characters:0:entity:description]
- [node:field_characters:1:entity:description]
- [node:field_characters:2:entity:description]

Description: [node:field_description]
```
