<?php

declare(strict_types=1);

namespace Drupal\ai_dropsolid\Plugin\EmbeddingStrategy;

use Drupal\ai_search\Attribute\EmbeddingStrategy;
use Drupal\ai_search\EmbeddingStrategyInterface;
use Drupal\ai_search\Plugin\EmbeddingStrategy\EmbeddingBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a recursive chunking embedding strategy for Dropsolid AI.
 *
 * This strategy uses intelligent recursive text chunking to create contextually
 * enriched vector representations suitable for advanced search and retrieval
 * operations. The strategy respects text boundaries and maintains semantic
 * coherence across chunks.
 */
#[EmbeddingStrategy(
  id: 'ds_contextual_text_chunks',
  label: new TranslatableMarkup('Enriched Embedding Strategy (Recursive Text Chunking)'),
  description: new TranslatableMarkup('<strong>Dropsolid:</strong> Enriched Composite Embedding workflow that swaps in a character-based recursive text chunker instead of the TikToken-driven chunker.'),
)]
final class RecursiveEmbeddingStrategy extends EmbeddingBase implements EmbeddingStrategyInterface {

  /**
   * {@inheritdoc}
   */
  public static function create(
    ContainerInterface $container,
    array $configuration,
    $plugin_id,
    $plugin_definition,
  ): static {
    /** @var \Drupal\ai\Utility\TextChunker $recursive_text_chunker */
    $recursive_text_chunker = $container->get('ai_dropsolid.recursive_text_chunker');

    /** @var static $instance */
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);

    // Replace the default chunker with the recursive implementation.
    $instance->textChunker = $recursive_text_chunker;

    return $instance;
  }

}
