# AI Experience Wizard

A comprehensive Drupal module for managing AI provider integrations with automatic installation, configuration, and key management.

## Features

- **Automatic Provider Installation**: Install AI provider modules via Package Manager
- **Unified Configuration**: Centralized configuration interface for all AI providers
- **Automatic Key Management**: Secure storage of API keys using the Key module
- **Form Preprocessing**: Intelligent form transformation for better user experience
- **Extensible Architecture**: Easy to add new AI providers
- **Developer-Friendly**: Comprehensive documentation and examples

## Requirements

- Drupal 11.x
- PHP 8.1+
- Package Manager module
- Key module
- Composer

## Installation

1. **Enable the module**:
   ```bash
   ddev drush en ai_experience_wizard
   ```

2. **Run the AI Experience Wizard**:
   - Navigate to `/ai-experience-wizard`
   - Step 1: Select your preferred AI provider
   - Step 2: Configure the selected provider (embedded provider config form)
   - Step 3: Select recipes to apply and finish the wizard

## Configuration

### Provider Registry

All providers are defined in `src/Config/AiProviderRegistry.php`:

```php
public const PROVIDERS = [
  'dropsolid_ai' => [
      'label' => 'Dropsolid AI',
      'package' => 'drupal/ai_provider_dropsolidai',
      'module' => 'ai_provider_dropsolidai',
      'config_name' => 'ai_provider_dropsolidai.settings_form',
      'form_class' => 'Drupal\ai_provider_dropsolidai\Form\DropsolidAiConfigForm',
      'description' => 'Provides Dropsolid AI integration for the Drupal AI module.',
      'icon' => 'dropsolidai',
      'website' => 'https://dropsolid.ai',
    ],
  // Add more providers here
];
```
