# AI Featured Image

**AI Featured Image** is a Drupal 11 module that automatically generates featured images for new nodes using artificial intelligence. Leveraging the DALL·E API (OpenAI), it creates a unique image based on the node's title and content, and automatically assigns it to the configured image field.

Ideal for news sites, blogs, government portals, or any site that needs to visually enrich its content without relying on a designer.

---

## ✨ Key Features

- **Per content type configuration**: Enable automatic image generation only for the bundles you select.
- **Configurable image field**: Specify the field where the generated image will be stored.
- **Custom prompt**: Define a template to describe what the AI should generate (e.g., `Header about: [title] - [body]`).
- **Placeholder replacement**: Automatically replaces `[title]`, `[body]`, and other fields.
- **Integration with DALL·E (OpenAI)**: Directly calls the API to generate the image.
- **Automatic storage**: The image is saved in `public://ai_images/` as a File entity.

---

## 🔐 Requirements

- An OpenAI account with access to the image generation API (DALL·E).
- A valid API key.
- HTTPS connection enabled on the server.
- An image field (e.g., `field_image`) configured on the target content types.

---

## 📍 How to Use

1. Install the module as usual (via Composer or manually).
2. Go to the configuration page: `/admin/config/content/ai-featured-image`
3. Enter your OpenAI API Key.
4. Select the content types where the feature should apply.
5. Specify the image field (e.g., `field_image`).
6. Optionally, customize the prompt to generate more relevant images.

You can use placeholders in the prompt such as:

- `[title]` → Replaced with the node title
- `[body]` → Replaced with the node body (if available)



## 🔄 Roadmap (future versions)

- Support for Media fields.
- Preview image before saving.
- Support for other models (Stable Diffusion, Replicate, Gemini, Claude).
- Usage limits per user or role.
- Integration with editorial workflows.

---

## 📘 License

This project is licensed under the [GNU General Public License v2.0 or later](LICENSE.txt).