<?php

namespace Drupal\ai_featured_image\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class SettingsForm extends ConfigFormBase {

  public function getFormId(): string {
    return 'ai_featured_image_settings';
  }

  protected function getEditableConfigNames(): array {
    return ['ai_featured_image.settings'];
  }

  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('ai_featured_image.settings');

    $form['enabled'] = [
        '#type' => 'checkbox',
        '#title' => $this->t('Enable automatic image generation'),
        '#default_value' => $config->get('enabled') ?? FALSE,
    ];

    $form['openai_api_key'] = [
        '#type' => 'textfield',
        '#title' => $this->t('OpenAI API Key'),
        '#default_value' => $config->get('openai_api_key'),
        '#required' => TRUE,
        '#maxlength' => 512,
        '#size' => 80,
    ];

    $form['enabled_content_types'] = [
        '#type' => 'checkboxes',
        '#title' => $this->t('Enabled content types'),
        '#options' => node_type_get_names(),
        '#default_value' => $config->get('enabled_content_types') ?? [],
    ];

    $form['image_field'] = [
        '#type' => 'textfield',
        '#title' => $this->t('Field machine name to store image'),
        '#description' => $this->t('Example: field_image'),
        '#default_value' => $config->get('image_field'),
    ];

    $form['prompt_template'] = [
        '#type' => 'textfield',
        '#title' => $this->t('Prompt template'),
        '#default_value' => $config->get('prompt_template') ?? 'Header image about: [title]',
        '#description' => $this->t('You can use placeholders like [title] for the node title and [body] for the content body. Example: \"Illustration of: [title] - [body]\".'),
    ];

    return parent::buildForm($form, $form_state);
  }

  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('ai_featured_image.settings')
        ->set('enabled', $form_state->getValue('enabled'))
        ->set('openai_api_key', $form_state->getValue('openai_api_key'))
        ->set('enabled_content_types', array_filter($form_state->getValue('enabled_content_types')))
        ->set('image_field', $form_state->getValue('image_field'))
        ->set('prompt_template', $form_state->getValue('prompt_template'))
        ->save();

    parent::submitForm($form, $form_state);
  }
}
