# AI Generation

⚠️ **Status: Very early development. Experimental project. Do not use on production sites.**

AI Generation is a Drupal module that allows you to generate **modules**, **themes**, and **configuration** (content types, fields, views, vocabularies, webforms, Search API/Solr, etc.) using AI.

It integrates with the [AI module](https://www.drupal.org/project/ai) and leverages your configured AI provider (such as OpenAI) to scaffold Drupal-ready code and configuration files directly inside your site.

---

## Features

- Generate **custom modules** and **themes** under `modules/custom` and `themes/custom`.
- Generate **configuration YAML** directly under your `config/sync` directory (import with `drush cim`).
- Create:
  - Content types, fields, and displays.
  - Views, vocabularies, and terms.
  - Webforms and related configuration.
  - Search API and Solr configuration (servers, indexes).
- Provides a **configuration form** (`/admin/config/ai/ai-generation`) to enter prompts.
- Provides a **Drush command**:  
  ```bash
  drush ai_generation:generate "Create a content type called Event"
  drush ai_generation:generate "Create a view"
  drush ai_generation:generate "Create a vocabulary called Fruits"
  drush ai_generation:generate "Create custom module that does ...... features"
  drush ai_generation:generate "Create custom theme that does ...... features"

