(function (Drupal, once) {
  'use strict';

  // Experimental transcription voice to text in real time. Just works in English
  Drupal.behaviors.voiceRecorder = {
    attach: function (context) {
      once('voiceRecorder', 'button[data-speech-record="1"]', context).forEach((btn) => {
        const form = btn.closest('form');
        if (!form) return;
        const textarea = form.querySelector('textarea.ai-prompt');
        if (!textarea) return;

        const RecognitionCtor = window.SpeechRecognition || window.webkitSpeechRecognition;
        if (!RecognitionCtor) {
          btn.disabled = true;
          btn.textContent = 'Speech recognition not supported in this browser';
          return;
        }

        const recognition = new RecognitionCtor();
        recognition.continuous = true;
        recognition.interimResults = true;
        recognition.lang = document.documentElement.lang || navigator.language || 'en-US';

        let active = false;
        let finalTranscript = '';
        let originalValue = '';
        let raf = 0;

        const render = (interim) => {
          if (raf) return;
          raf = requestAnimationFrame(() => {
            const combined = [originalValue, finalTranscript, interim].join(' ').replace(/\s+/g, ' ').trim();
            textarea.value = combined;
            textarea.dispatchEvent(new Event('input', { bubbles: true }));
            raf = 0;
          });
        };

        recognition.onresult = (event) => {
          let interim = '';
          for (let i = event.resultIndex; i < event.results.length; i++) {
            const res = event.results[i];
            if (res.isFinal) {
              finalTranscript += res[0].transcript + ' ';
            } else {
              interim += res[0].transcript + ' ';
            }
          }
          render(interim);
        };

        recognition.onend = () => {
          if (active) {
            try { recognition.start(); } catch (e) {}
          } else {
            btn.setAttribute('aria-pressed', 'false');
            btn.classList.remove('is-recording');
          }
        };

        const start = () => {
          if (active) return;
          active = true;
          finalTranscript = '';
          originalValue = textarea.value;
          btn.setAttribute('aria-pressed', 'true');
          btn.classList.add('is-recording');
          try { recognition.start(); } catch (e) {}
        };

        const stop = () => {
          if (!active) return;
          active = false;
          try { recognition.stop(); } catch (e) {}
        };

        btn.addEventListener('click', (e) => { e.preventDefault(); e.stopPropagation(); });

        btn.addEventListener('pointerdown', (e) => { e.preventDefault(); start(); });
        ['pointerup','pointerleave','pointercancel','mouseup','mouseleave','touchend'].forEach((ev) => {
          btn.addEventListener(ev, stop);
        });

        btn.addEventListener('keydown', (e) => {
          if (e.code === 'Space' || e.key === ' ' || e.key === 'Spacebar' || e.key === 'Enter') {
            e.preventDefault(); start();
          }
        });
        btn.addEventListener('keyup', (e) => {
          if (e.code === 'Space' || e.key === ' ' || e.key === 'Spacebar' || e.key === 'Enter') {
            e.preventDefault(); stop();
          }
        });
      });
    }
  };
})(Drupal, once);
