<?php

namespace Drupal\ai_llms_txt_generator\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Response;
use Drupal\Core\Config\ConfigFactoryInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Controller for serving the LLMs.txt file.
 */
class LlmsTxtController extends ControllerBase {

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a LlmsTxtController object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory')
    );
  }

  /**
   * Serves the LLMs.txt content.
   *
   * @return \Symfony\Component\HttpFoundation\Response
   *   The response containing LLMs.txt content.
   */
  public function content() {
    $config = $this->configFactory->get('ai_llms_txt_generator.settings');
    $content = $config->get('generated_content') ?: $config->get('content') ?: '';

    if (empty($content)) {
      $content = "# LLMs.txt\n\nNo content generated yet. Please configure and generate content in the admin settings.";
    }

    $response = new Response($content);
    $response->headers->set('Content-Type', 'text/plain; charset=utf-8');
    $response->headers->set('X-Robots-Tag', 'noindex');

    return $response;
  }

}
