<?php

namespace Drupal\Tests\ai_logging\Functional;

use Drupal\ai\OperationType\Chat\ChatInput;
use Drupal\ai\OperationType\Chat\ChatMessage;
use Drupal\Tests\BrowserTestBase;

/**
 * Contains AI Logging UI setup functional tests.
 *
 * @group ai_logging
 */
class AiLoggingUiTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'ai',
    'ai_test',
    'ai_logging',
    'user',
    'system',
    'views_ui',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * A user with permission to bypass access content.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->adminUser = $this->drupalCreateUser([
      'access administration pages',
      'administer ai',
      'administer ai providers',
      'administer ai log',
      'view ai log',
    ]);
  }

  /**
   * Set up module.
   */
  public function testBasicSetup(): void {
    $this->drupalLogin($this->adminUser);

    // Keep the indexed content minimal since the MySQL Vector embedding has
    // low accuracy in the tests.
    $this->drupalGet('admin/config/ai/logging/settings');
    $this->submitForm([
      'prompt_logging' => TRUE,
      'prompt_logging_output' => TRUE,
    ], 'Save configuration');

    // Send a test message and get a response.
    $text = 'Can you help me with something?';
    $provider = \Drupal::service('ai.provider')->createInstance('echoai');
    $input = new ChatInput([
      new ChatMessage('user', $text),
    ]);
    $provider->chat($input, 'test');

    $this->drupalGet('admin/config/ai/logging/collection');
    $this->assertSession()->elementTextContains(
      'css',
      '.views-element-container tbody .views-field-prompt',
      $text,
    );
    $this->assertSession()->elementTextContains(
      'css',
      '.views-element-container tbody .views-field-provider',
      'echoai',
    );
  }

}
