
## Introduction

The AI Migration module is under active development. Please let us know in the issue queue if you are interested in participating.

This module helps with migrating content into Drupal using AI to parse web pages based on your Drupal content type schema, generating migrations, that migrate the content creating Drupal nodes.

### Goals

- To make it easier to parse fairly unstructured content from web pages or documents and transform it into structured content in Drupal. "Fill the fields, not bloat the body."
- To make it easy to migrate slices of content into a Drupal instance to support phased migration of legacy sites into Drupal sites.
- Spend less time tuning migrations and more time migrating.

## Requirements

This module requires:
- drupal/ai:^1.2@alpha
- drupal/jsonapi
- drupal/migrate:^6.0
- drupal/migrate_plus:^6.1
- drupal/serialization
- drupal/schemata:^1.0
- drupal/schemata_json_schema

## Recommended Models

We recommend using these models with AI Migration:
- OpenAI GPT-4.1-mini
- OpenAI GPT-5-nano
- Gemini 2.5 Flash

We are currently addressing compatibility issues with Anthropic Claude.

## Installation & Configuration

1. Install the module as you would any other module.
2. Configure an AI API provider at /admin/config/ai/providers.
3. Set the default AI API provider for Chat and Chat with Structured Response at /admin/config/ai/settings.
4. Create a Drupal content type with fields that you want to populate with migrated content.
5. Create a migration yml file in your custom module. See the `simple_content_migration.yml` file in the `ai_migration_example` submodule for an example.
6. Execute the migration to migrate content.

## AI Migration Example

Provides a sample migration that demonstrates AI Migration functionality. The submodule creates a content type called 'Simple Content Migration' that has fields that can be populated by the `simple_content_migration.yml` migration. The `simple_content_migration.yml` migration is a good starting point for creating your own migrations. The migration targets CA example website https://accessibility.civicactions.com/ and converts blog posts into Drupal nodes.

## Caching ##

The module creates a cache bin where combinations of AI responses keyed by provider-model-prompt are stored. This way, identical queries to the same model will not incur additional costs from the provider. Keep in mind that clearing all caches also clears out the AI Migration cache.


## Developers and Contributors

See [CONTRIBUTING.md](CONTRIBUTING.md) for details on how to set up a local development environment and contribute.

## More Documentation

See our [additional documentation](https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/ai-migration) for more details.
