<?php

namespace Drupal\ai_migration\EventSubscriber;

use Drupal\migrate\Event\MigrateEvents;
use Drupal\migrate\Event\MigratePreRowSaveEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Subscribes to the migration pre-save event.
 */
class MigrationPreRowSaveSubscriber implements EventSubscriberInterface {

  /**
   * Reacts to the pre-save event for a migration.
   *
   * @param \Drupal\migrate\Event\MigratePreRowSaveEvent $event
   *   The pre-row-save event.
   */
  public function onPreRowSave(MigratePreRowSaveEvent $event): void {
    // Get the row being migrated.
    $row = $event->getRow();

    // Get the values from the 'row' key in the destination array.
    $values = $row->getDestination()['row'];
    $row->removeDestinationProperty('row');

    // Set each value as a destination property.
    foreach ($values as $property => $value) {
      if (!$row->hasDestinationProperty($property)) {
        // Only set the property if it hasn't been set by a process plugin.
        // This means process plugins have priority over this event subscriber.
        $row->setDestinationProperty($property, $value);
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      MigrateEvents::PRE_ROW_SAVE => 'onPreRowSave',
    ];
  }

}
