<?php

namespace Drupal\ai_migration\Plugin\migrate\process;

use Drupal\migrate\Attribute\MigrateProcess;
use Drupal\migrate\ProcessPluginBase;
use Drupal\migrate\MigrateExecutableInterface;
use Drupal\migrate\Row;

/**
 * Process plugin that passes complete source row to the destination.
 *
 * It does this without any transformation.
 * It's useful when you need to preserve all source data or
 * process it later in the migration pipeline.
 */
#[MigrateProcess(
  id: "row_passthrough",
  handle_multiples: FALSE,
)]
class RowPassthrough extends ProcessPluginBase {

  /**
   * {@inheritdoc}
   */
  public function transform($value, MigrateExecutableInterface $migrate_executable, Row $row, $destination_property) {
    // Simply return the array of source values so that we can access them
    // in a later in a preRowSave event subscriber.
    $source = $row->getSource();
    return $source;
  }

}
