<?php

declare(strict_types=1);

namespace Drupal\ai_migration\Service;

use Drupal\Core\Cache\CacheBackendInterface;

/**
 * Provides a cache service for AI migration responses.
 */
class AiMigrationCacheBinProvider extends AiMigrationCacheProviderBase {

  public const CACHE_PROMPT_CID_PREFIX = 'prompt';

  /**
   * The cache backend.
   *
   * @var \Drupal\Core\Cache\CacheBackendInterface
   */
  protected $cache;

  /**
   * Constructs the AiMigrationCache service.
   *
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache
   *   The cache backend.
   */
  public function __construct(CacheBackendInterface $cache) {
    $this->cache = $cache;
  }

  /**
   * {@inheritdoc}
   */
  public function getPromptCacheId(string $prompt, string $provider_id, string $model_id): string {
    return $this->buildCacheId(self::CACHE_PROMPT_CID_PREFIX, $this->hashContent($prompt, $provider_id, $model_id));
  }

  /**
   * {@inheritdoc}
   */
  public function getPromptResponse(string $prompt, string $provider_id, string $model_id): ?array {
    $cid = $this->getPromptCacheId($prompt, $provider_id, $model_id);
    $cache = $this->cache->get($cid);
    return ($cache) ? $cache->data : NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function setPromptResponse(array $response, string $prompt, string $provider_id, string $model_id, $expire = CacheBackendInterface::CACHE_PERMANENT): void {
    $cid = $this->getPromptCacheId($prompt, $provider_id, $model_id);
    $this->cache->set($cid, $response, $expire);
  }

}
